function [uniq_feats, combo_feats] = clusterFeatures(cluster, partition)
% Return features/constraints for Slurm scheduler

% Copyright 2022 The MathWorks, Inc.

narginchk(1,2)

if ~isa(cluster,'parallel.cluster.Generic')
    error('Must provide a cluster object.')
end

% The plugin scripts are not on the path.  Need to change directories to it first.  Tried calling
% feval instead, but  feval(/very/long/path/to/plugin/scripts/fcn) won't work.
odir = cd(cluster.PluginScriptsLocation);
% Change back to the old directory on cleanup
x = onCleanup(@()cd(odir));
rc = getRemoteConnection(cluster);

if nargin==1
    part = "";
else
    part = "-p" + partition;
end

% Get list of unique features (based on the partition, if supplied)
commandToRun = sprintf("sinfo %s -O Features:60 | tail -n +2 | tr ',' '\\n' | tr -d ' ' | sort -u", part);
[FAILED, uniq_feats] = rc.runCommand(commandToRun);
uniq_feats = strtrim(uniq_feats);
if FAILED~=false
    error("Failed to get features: " + uniq_feats)
end
uniq_feats = strsplit(uniq_feats)';

% Get list of features that can work together.  For example, if a user
% requests an "EPYC", it wouldn't also make sense to request "E5-2640"
commandToRun = sprintf("sinfo %s -O Features:60 | tail -n +2 | tr -d ' ' | sort -u", part);
[FAILED, combo_feats] = rc.runCommand(commandToRun);
combo_feats = strtrim(combo_feats);
if FAILED~=false
    error("Failed to get features: " + combo_feats)
end
combo_feats = strsplit(combo_feats)';

end
