function qs = clusterQueueNames(cluster)
% Return cluster queue names

% Copyright 2022 The MathWorks, Inc.

narginchk(1,1)

if ~isa(cluster,'parallel.cluster.Generic')
    error('Must provide a cluster object.')
end

% The plugin scripts are not on the path.  Need to change directories to it first.  Tried calling
% feval instead, but  feval(/very/long/path/to/plugin/scripts/fcn) won't work.
odir = cd(cluster.PluginScriptsLocation);
% Change back to the old directory on cleanup
x = onCleanup(@()cd(odir));
rc = getRemoteConnection(cluster);

commandToRun = "sinfo -o %R --noheader | sort";
[FAILED, qs] = rc.runCommand(commandToRun);
qs = strtrim(qs);
if FAILED~=false
    error("Failed to get queues: " + qs)
end

qs = strsplit(qs)';

end
